/*
Programm par Maniack Crudelis.
http://www.crudelis.fr.tc
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
*/

#ifndef UTILITAIRE_H
#define UTILITAIRE_H

//#define WIN32
//#define __LINUX

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#ifdef WIN32    /*win*/
#include <conio.h>
#define CLEARSCREEN "cls"
#else /*linux*/
#include <iconv.h>
#define CLEARSCREEN "clear"
#endif

#define MAX 79      /*Largeur maximum de l'cran*/
#define NA 12345678 /*Valeur d'erreur renvoye pour les calculs*/
#define QUIT -12345678 /*Valeur indiquant la commande exit*/
#define defo 1111111 /*Valeur indiquant une saisi par dfaut pour les calculs*/

int ER; /*Variable de vrification des erreurs renvoyant NULL*/
int scf;    /*Variable de vrification des scanf*/
char chfunc[4096];
int affichage_arg;

#include "nomajloc.h"
#include "Chaines.h"
#include "Developpez.com.h"

void Fuck ();   /*indique une erreur dans le choix d'un menu*/
void Pause ();  /*Effectue une pause dans le programme*/
void DPause (); /*Double pause, utile lorsqu'il reste la valeur entre dans le buffer clavier. C'est le cas pour les saisie*/
void Titre (int argc,char *argv[], const char titr1[MAX+6], const char titr2 [MAX], const char couleur[100]);     /*Indique un titre pour la fentre, un titre dans l'cran console et les couleurs de la console*/
void startxterm (int argc,char *argv[], const char titr1[MAX+6], const char couleur[100]);  //Permet le dmarrage dans un xterm pour les environnements linux
char* getsfix (char* chaine, int taille);    //gets limit  255 char.
char* getsdyn (char* chaine);    //gets avec allocation dynamique de mmoire
float interpret_calc(const char calcul [255]); /*Demande la saisie d'un nombre ou d'un calcul*/
char* acc (const char* texte, char* chfunc);   /*Change le code ascii pour afficher les accents sur la console*/
char* invers_acc (const char* chaine, char* chfunc);    /*Permute les accents, en donnant les codes ascii correspondant pour l'ouverture de fichier*/
void putsacc (const char* chaine);    /*Puts affichant les caractres accentus. Prend en charge le /n*/
char* linux_acc (const char* texte, char* chfunc);  //Change les codes ascii pour afficher sur la console linux
char* linux_utf_to_iso (const char* texte, char* chfunc);    //Transforme la chaine d'entre UTF-8 en iso-latin (iso8859-1)
char* exp_iconv(char* chaine, const char* from_charset, const char* to_charset, char* chfunc);  //Conversion d'encodage de caractres en utilisant iconv
void Erreur (int nb_erreur);    /*Fonction vrifiant la possibilit d'une erreur*/
void Efface_char (char *chaine,const char *borne);    /*Efface les caractres d'une chane jusqu' la borne, puis efface la borne.*/
void Efface_n (char* chaine);   //Efface /n
void accent_redir_dos ();   /*Change la page de code du mode dos, ce qui permet  la commande dos de grer les accents. Trs utile dans le cas d'une redirection de sortie vers un fichier.*/
void annul_accent_redir_dos (); /*Rtablit la page de code normale du dos.*/
char* Local_user(char* user); /*Dtermine le login de l'utilisateur actuel*/
char* Disk_system (char* disque);   /*Dtermine la lettre du disque systme*/
char* inttochar (int entier, char* chaine);    /*Transforme un int en une chaine de caractre*/
void changeslash (char *chaine);     //Change les slash pour la compatibilit linux

void Fuck ()   /*indique une erreur dans le choix d'un menu*/
{
    printf("\n");
    printf("       ___  \n");
    printf("      |   |  \n");
    printf("      |\\_/|  \n");
    printf(" _____|   |__\n");
    printf("|  |  |   |  |\n");
    printf("|            |\n");
    printf("\\           /\n");
    printf(" \\         /\n");
    printf("  |       |                         Par Spob\n");
    Pause();
}

void Pause ()  /*Effectue une pause dans le programme*/
{
    printf("...");
    getchar();
}

void DPause () /*Double pause, utile lorsqu'il reste la valeur entre dans le buffer clavier. C'est le cas pour les saisie*/
{
    printf("...");
    getchar();
    getchar();
}

void Titre (int argc,char *argv[], const char titr1[MAX+6], const char titr2[MAX], const char couleur[100])     /*Indique un titre pour la fentre, un titre dans l'cran console et les couleurs de la console*/
{
    int i, ecart;
    #ifdef WIN32    /*win*/
    char titr [90] = "title "; /*Commande dos TITLE*/
    char col [20] = "color "; /*Commande dos COLOR*/
        if (strcmp(couleur,"0"))
        {
            strcat(col,couleur);    /*Concatne la commande et les couleur donne*/
            system(col);    /*Effectue la commande dos, ce qui changera les couleur de la fentre dos*/
        }
        strcat(titr,titr1);    /*Concatne la commande et le titre donn*/
        system(titr);    /*Effectue la commande dos, ce qui changera le titre de la fentre dos*/
    #else /*linux*/
        startxterm (argc,argv,titr1,couleur);
    #endif
    #ifdef WIN32    /*win*/
        printf("%c%c", 30,201);
    #else /*linux*/
        printf("</");
    #endif
    for (i=0;i<MAX-3;i++)
    {
        #ifdef WIN32    /*win*/
            printf("%c", 205);
        #else /*linux*/
            printf("-");
        #endif
    }
    #ifdef WIN32    /*win*/
        printf("%c%c", 187,30);
        printf("%c%c", 201,188);
    #else /*linux*/
        printf("\\>\n");
        printf("/ ");
    #endif
    for (i=0;i<MAX-3;i++)
        printf(" ");
    #ifdef WIN32    /*win*/
        printf("%c%c", 200,187);
        printf("%c", 186);
    #else /*linux*/
        printf(" \\\n");
        printf("|");
    #endif
    ecart = (MAX-(strlen(titr2)))/2; /*Calcul de l'cart pour centrer le titre*/
    for (i=0;i<ecart;i++)
        printf(" ");         /*cre l'cart*/
    printf("%s",acc(titr2,chfunc));           /*Affiche le titre*/
    for (i=ecart+2+strlen(titr2);i<MAX;i++)
        printf(" ");        /*Termine l'cart jusqu'au bout de la fentre (dfinit par MAX)*/
    #ifdef WIN32    /*win*/
        printf(" %c", 186);
        printf("%c%c", 200,187);
    #else /*linux*/
        printf(" |\n");
        printf("\\ ");
    #endif
    for (i=0;i<MAX-3;i++)
        printf(" ");
    #ifdef WIN32    /*win*/
        printf("%c%c", 201,188);
        printf("%c%c", 31,200);
        for (i=0;i<MAX-3;i++)
            printf("%c", 205);
        printf("%c%c\n", 188,31);
    #else /*linux*/
        printf(" /\n");
        printf("<\\");
        for (i=0;i<MAX-3;i++)
            printf("-");
        printf("/>\n");
    #endif
    puts("< q permet de quitter le programme. >");
}

void startxterm (int argc,char *argv[], const char titr1[MAX+6], const char couleur[100])
{
    char pwd[4096];
    char prog[4096];
    char args[2048] = "\0";
    int tab[50];
    char bgcolor[100];
    char fgcolor[100];
    char titre[255];
    int sw=1;
    if(argv[1] != NULL)
        sw = strcmp(argv[1],"swxterm");
    if(!isatty(1) || !sw)
    {
        if(strlen(couleur) == 2)    //Couleur DOS
        {   //Changement des couleurs dos en couleurs xterm
            for(tab[0]=0;tab[0]<2;tab[0]++) //Utilise tab[0] en variable de boucle
            {
                switch (couleur[tab[0]])
                {
                    case '0':
                        if(!tab[0])
                            sprintf(bgcolor,"black");
                        else
                            sprintf(fgcolor,"black");
                        break;
                    case '1':
                        if(!tab[0])
                            sprintf(bgcolor,"navy");
                        else
                            sprintf(fgcolor,"navy");
                        break;
                    case '2':
                        if(!tab[0])
                            sprintf(bgcolor,"green4");
                        else
                            sprintf(fgcolor,"green4");
                        break;
                    case '3':
                        if(!tab[0])
                            sprintf(bgcolor,"cyan4");
                        else
                            sprintf(fgcolor,"cyan4");
                        break;
                    case '4':
                        if(!tab[0])
                            sprintf(bgcolor,"red4");
                        else
                            sprintf(fgcolor,"red4");
                        break;
                    case '5':
                        if(!tab[0])
                            sprintf(bgcolor,"DarkMagenta");
                        else
                            sprintf(fgcolor,"DarkMagenta");
                        break;
                    case '6':
                        if(!tab[0])
                            sprintf(bgcolor,"yellow4");
                        else
                            sprintf(fgcolor,"yellow4");
                        break;
                    case '7':
                        if(!tab[0])
                            sprintf(bgcolor,"grey75");
                        else
                            sprintf(fgcolor,"grey75");
                        break;
                    case '8':
                        if(!tab[0])
                            sprintf(bgcolor,"grey50");
                        else
                            sprintf(fgcolor,"grey50");
                        break;
                    case '9':
                        if(!tab[0])
                            sprintf(bgcolor,"blue1");
                        else
                            sprintf(fgcolor,"blue1");
                        break;
                    case 'A':
                    case 'a':
                        if(!tab[0])
                            sprintf(bgcolor,"green");
                        else
                            sprintf(fgcolor,"green");
                        break;
                    case 'B':
                    case 'b':
                        if(!tab[0])
                            sprintf(bgcolor,"cyan1");
                        else
                            sprintf(fgcolor,"cyan1");
                        break;
                    case 'C':
                    case 'c':
                        if(!tab[0])
                            sprintf(bgcolor,"red1");
                        else
                            sprintf(fgcolor,"red1");
                        break;
                    case 'D':
                    case 'd':
                        if(!tab[0])
                            sprintf(bgcolor,"magenta1");
                        else
                            sprintf(fgcolor,"magenta1");
                        break;
                    case 'E':
                    case 'e':
                        if(!tab[0])
                            sprintf(bgcolor,"yellow1");
                        else
                            sprintf(fgcolor,"yellow1");
                        break;
                    case 'F':
                    case 'f':
                        if(!tab[0])
                            sprintf(bgcolor,"white");
                        else
                            sprintf(fgcolor,"white");
                        break;
                }
            }
        }
        else
        {   //Couleur dj pour xterm
            strcpy(bgcolor,couleur);
            index_ch(bgcolor,":",tab);
            bgcolor[tab[0]] = '\0'; //Coupe au :
            strcpy(fgcolor,couleur);
            Efface_char(fgcolor,":");
        }
        if(argv[0][0] == '/')
        {
            strcpy(pwd,argv[0]);
            pwd[tab[index_ch(pwd,"/",tab)-1]] = '\0';    //Termine la chaine au dernier /
        }
        else
            getcwd(pwd,4096);   //pwd prend le chemin absolu de l'excutable
        argv[0] = strrchr(argv[0],'/'); //Efface jusqu'au dernier /, afin de ne garder que /fichier, sans le chemin
        if(argc > 1)    //Seulement si plus d'un arg
        {
            if(argc == 2 && !sw)
            {/*2 arguments, mais le second est swxterm. Hors ce dernier ne doit pas tre renvoy au programme*/}
            else
            {   //Prpare la construction de la chaine des arguments
                if(!sw) //argv[1] = swxterm, donc ignorer le premier argument
                    sw=2;   //La copie commencera au 3e arg, aprs swxterm.     Sinon, sw=1, donc il commencera au 2e arg.
                strcpy(args,argv[sw++]);  //Copie du premier argument
                for(;sw<argc;sw++)
                {
                    strcat(args," ");   //Ajoute un espace  la chaine des arguments
                    strcat(args,argv[sw]);  //Puis l'argument suivant
                }
            }
        }
        sprintf(prog,"cd \"%s\"; \".%s\" %s",pwd,argv[0],args);
        strcpy(titre,linux_acc(titr1,chfunc));   //Corrige les accents sur le titre et rutilise args pour stocker la chaine.
        if(execlp("xterm","xterm","-sb","-rightbar","-T",titre,"-bg",bgcolor,"-fg",fgcolor,"-e",prog,NULL) == -1)
        {   //Si execl renvoi -1, erreur lors de l'excution de xterm, xterm n'est peut-tre pas prsent
            putsacc("\nxterm n'a pas t trouv, il est conseill d'installer xterm.\n");
            if(!isatty(1))  //Si l'excution ne se fait pas depuis un terminal
            {
                system("echo \"xterm n'a pas t trouv, il est ncessaire pour une utilisation de Servus Domini hors terminal.\" > temp.tmp");
                system("echo \"Sans xterm, Servus Domini doit tre excut depuis le terminal.\" >> temp.tmp");
                system("xdg-open temp.tmp");    //Ouvre le fichier texte quelque que soit le logiciel associ
                system("rm temp.tmp");  //Supprime le fichier aprs ouverture
            }
            //Lance le programme sans passer par xterm
            strcpy(prog,pwd);
            strcat(prog,argv[0]);
            if(args[0] == '\0') //Si pas d'arguments
                execl(prog,prog,NULL);
            else    //Avec arguments
                execl(prog,prog,args,NULL);
        }
    }
}

char* getsdyn (char* chaine)    //gets avec allocation dynamique de mmoire
{
/*Utilisation de cette fonction:
Dclarer un pointeur sur une chaine de caractre -> char* chaine;
Appeler getsdyn et rcuprer le pointeur
chaine = getsdyn(chaine);
La saisie de l'utilisateur est stocke dans la variable chaine.
ATTENTION, ne pas oublier le free, aprs utilisation de la chaine.
free(chaine);*/
    char caractere;
    int nb=0,max=100;
    ER = (int) (chaine = (char*) calloc(max,sizeof(char)));
    Erreur(1);
    while ((caractere = getchar()) != 10)
    {    //Tant que l'utilisteur ne presse pas 'entre'
        if (++nb > max)    //Si la chaine n'est pas asse grande
        {
            max+=100;        //Augmente de 100 caractres
            ER = (int) (chaine = (char*) realloc(chaine,max*sizeof(char)));
            Erreur(1);
        }
        chaine[nb-1] = caractere;   //Place le caractre  la suite de la chaine
    }
    max+=100;        //Augmente de 100 caractres
    ER = (int) (chaine = (char*) realloc(chaine,max*sizeof(char))); //Ajoute de la place pour les modif de caractres accentus
    Erreur(1);
    chaine[nb] = '\0';        //Termine la chaine
    return (chaine);
}

char* getsfix (char* chaine, int taille)    //gets  taille limite.
{
    fgets(chaine,taille,stdin);
    fclean(chaine,stdin);    //Purge le buffer pour nettoyer les ventuels caractres qui ne sont pas entrs dans la chaine
    return (chaine);
}

float interpret_calc(const char calcul [100]) /*Demande la saisie d'un nombre ou d'un calcul*/
{
    char chaine[100], signes[50];
    float nombres[50];
    int i,j,k,b1=0,b2=0,b3,nbparo=0,nbparf=0,nbmuldiv=0,nbt=0,index=0;
    int indexparo[50], indexparf[50], indexmuldiv[50];
    float temp,nb1,nb2;
    if(calcul[0] == '\0')   //Si la chaine envoye en arg est vide 1er caractre =  \0
        strcpy(chaine,nomajloc_interpret_calc(chfunc));     //saisie clavier,
    else
        strcpy(chaine,calcul);  //Utilise la chaine envoye en arg.
    i = strlen(chaine);    /*i = taille complte du calcul*/
    if (!i)    /*Si la chaine est vide, renvoi une erreur*/
        return (defo);
    while (strlen(chaine))
    {
        if (isdigit(chaine[0]) > 0)
        {        /*Si le premier caractre est un chiffre*/
            b1=1;        /*indique nombres*/
            nombres[index] = atof(chaine);    /*Saisi valeur et stocke dans le tableau 1*/
            if (b2==1)            /*Valeur ngative*/
                nombres[index]*=-1;
            b2=0;
            signes[index++] = '0';      /*Met 0 dans le tableau 2*/
            nbt++;
            while (isdigit(chaine[0]) || chaine[0] == '.')
            {            /*retire la valeur saisie de la string*/
                for (i=0;i<(int)strlen(chaine);i++)
                    chaine[i] = chaine[i+1];
            }
        }
        else
        {        /*Donc si signe de calcul*/
            if (chaine[0] == '-' && b1 == 0)
            {            /*Si un - se trouve apres un autre signe*/
                b2=1;            /*Nombre ngatif*/
                nombres[index] = 0;     /*Place 0 et # dans les tableaux*/
                signes[index++] = '#';
                nbt++;
            }
            else
            {    /*Si c'est pas un nb ngatif*/
                b1=0;      /*Indique signe*/
                signes[index] = chaine[0];   /*Place 0 dans le tableau 1 et le signe dans le tableau 2*/
                nombres[index++] = 0;
                nbt++;
                switch (signes[index-1])
                {        /*reperage du signe utilis*/
                    case '*':
                    case '/':
                        indexmuldiv[nbmuldiv] = index-1;
                        nbmuldiv+=1;
                        break;
                    case '(':
                        indexparo[nbparo] = index-1;
                        nbparo+=1;
                        break;
                    case ')':
                        indexparf[nbparf] = index-1;
                        nbparf+=1;
                        break;
                    case '+':
                    case '-':
                        break;
                    default:   /*Si aucun signe n'est reconnu*/
                        printf("Erreur: le symbole %c n'est pas reconnu", signes[index-1]);
                        Pause();
                        return NA;
                }
            }
            for (i=0;i<(int)strlen(chaine);i++)
                chaine[i] = chaine[i+1]; /*Retire le signe de la string*/
        }
    }
    if (nbparo != nbparf)
    {    /*Si ya pas autant de parenthses ouvrantes et fermantes*/
        printf("Erreur: %d %s ouvertes, %d %s fermees", nbparo, acc("parenthses",chfunc) ,nbparf, acc("parenthses",chfunc));
        Pause();
        return NA;
    }
    do
    {
        if (nbparo) /*Si ya des parentheses*/
        {
            b2 = indexparf[0];     /*borne 2  la 1ere parenthse fermante*/
            for (i=0;i<nbparo;i++)
            {
                if (indexparo[i] < b2)  /*Si la parenthese ouvrante est avant la fermante*/
                    b1 = indexparo[i];  /*borne 1  la parenthese*/
            }                    /*Donc les 2 bornes se resserrent sur les plus profondes parenthses*/
            signes[b1] = '#';   /*Place des #  la place des parenthses utilises*/
            signes[b2] = '#';
            nbparo--;
            for (i=b1;i<nbparo;i++)     /*Supprime les index des parenthses utilises*/
                indexparo[i] = indexparo[i+1];
            for (i=0;i<nbparo;i++)
                indexparf[i] = indexparf[i+1];
        }
        else
        {        /*Si ya pas de parenthses, ou plus de parenthses*/
            b1 = -1;     /*Bornes  -1 et max*/
            b2 = nbt;
        }
        for (i=0;i<nbmuldiv;i++)
        {        /*Boucle sur le nombre de signes * ou / */
            if (indexmuldiv[i] > b1 && indexmuldiv[i] < b2)
            {            /*Si le signe se trouve entre les 2 bornes*/
                b3 = indexmuldiv[i];    /*Borne 3  l'emplacement du signe*/
                indexmuldiv[i] = -1;    /*index du signes  -1*/
            }
            else
                b3 = -1;  /*sinon borne 3  -1*/
            if (b3 != -1)
            {    /*Si la borne 3 est utilise*/
                for(j=b3-1;j>b1;j--)
                {       /*Saisi valeur 1*/
                    if (nombres[j] || (!nombres[j] && signes[j] == '0'))
                    {      /*Si le nombre est diffrent de 0 ou qu'il est gal  0 et que le tab 2 contient aussi 0*/
                        nb1 = nombres[j];
                        signes[j] = '#';   /*Place 0 et # dans les tableaux*/
                        nombres[j] = 0;
                        break;
                    }
                }
                for(k=b3+1;k<b2;k++)
                {       /*Saisi valeur 2... idem*/
                    if (nombres[k] || (!nombres[k] && signes[k] == '0'))
                    {
                        nb2 = nombres[k];
                        signes[k] = '#';
                        nombres[k] = 0;
                        break;
                    }
                }
                if (k==b2)
                {   /*Si aucune valeur n'est trouve pour nb2*/
                    nombres[j] = nb1;   /*Replace nb1 dans le tableau 1, puis met 0 dans le tableau 2*/
                    signes[j] = '0';
                }
                if (signes[b3] == '*')
                    temp = nb1*nb2;      /*Multiplication*/
                if (signes[b3] == '/')
                {
                    if (nb2 == 0)
                    {
                        puts("Erreur: Division par 0 !!!");
                        Pause();
                        return NA;
                    }
                    temp = nb1/nb2;     /*Division*/
                }
                signes[b3] = '0';    /*Met 0 dans le tableau 2*/
                nombres[b3] = temp;  /*Place le rsultat du calcul dans le tableau 1*/
            }
        }
        for(i=b1+1;i<b2;i++)
        {
            for(j=b1+1;j<b2;j++)
            {         /*Saisi valeur 1*/
                if (nombres[j] != 0 || (!nombres[j] && signes[j] == '0'))
                {
                    nb1 = nombres[j];
                    signes[j] = '#';
                    nombres[j] = 0;
                    break;
                }
            }
            for(k=b1+1;k<b2;k++)
            {        /*Saisi valeur 2*/
                if (nombres[k] || (!nombres[k] && signes[k] == '0'))
                {
                    nb2 = nombres[k];
                    signes[k] = '#';
                    nombres[k] = 0;
                    break;
                }
            }
            if (k==b2)
            {
                nombres[j] = nb1;
                signes[j] = '0';
            }
            for(j=b1+1;j<b2;j++)
            {
                switch (signes[j])
                {
                    case '+':
                        temp = nb1+nb2;     /*Addition*/
                        break;
                    case '-':
                        temp = nb1-nb2;     /*Soustraction*/
                        break;
                }
                if (signes[j] == '+' || signes[j] == '-')
                {      /*Si addition ou soustraction*/
                    signes[j] = '0';     /*Met 0 dans le tableau 2*/
                    nombres[j] = temp;   /*Et le resultat du calcul dans le tableau 1*/
                    break;
                }
            }
        }
    } while (b1 != -1 || b2 != nbt); /*Fin du calcul si les bornes sont maximum*/
    i=0;
    do
    {
        temp = nombres[i];    /*Prend comme rsultat la seule valeur restant dans le tableau*/
    } while (!temp && ++i<nbt);
    return temp; /*Renvoi le rsultat du calcul*/
}

void putsacc (const char chaine[255])    /*Puts affichant les caractres accentus. Prend en charge le /n*/
{
    char chaine_modif[512];
    strcpy(chaine_modif,chaine);
    printf("%s", acc(chaine_modif,chfunc));
}

char* acc (const char* texte, char* chfunc)   /*Change le code ascii pour afficher les accents sur la console*/
{
    #ifdef WIN32    /*win*/
    int i, j;
    for (i=0,j=0;i<=(int)strlen(texte);i++,j++)
    {
        if(texte[i] == -61)    //Caratre cod en utf-8
            i++;    //Saute au caractre suivant (UTF-8 est cod sur 2 valeur, ici c'est la seconde qui nous intresse
        switch(texte[i])
        {
            case '':
            case -68:   //utf-8
                chfunc[j] = 129;
                break;
            case '':
            case -87:   //utf-8
                chfunc[j] = 130;
                break;
            case '':
            case -94:   //utf-8
                chfunc[j] = 131;
                break;
            case '':
            case -92:   //utf-8
                chfunc[j] = 132;
                break;
            case '':
            case -96:   //utf-8
                chfunc[j] = 133;
                break;
            case '':
            case -89:   //utf-8
                chfunc[j] = 135;
                break;
            case '':
            case -86:   //utf-8
                chfunc[j] = 136;
                break;
            case '':
            case -85:   //utf-8
                chfunc[j] = 137;
                break;
            case '':
            case -88:   //utf-8
                chfunc[j] = 138;
                break;
            case '':
            case -81:   //utf-8
                chfunc[j] = 139;
                break;
            case '':
            case -82:   //utf-8
                chfunc[j] = 140;
                break;
            case '':
            case -84:   //utf-8
                chfunc[j] = 141;
                break;
            case '':
            case -76:   //utf-8
                chfunc[j] = 147;
                break;
            case '':
            case -74:   //utf-8
                chfunc[j] = 148;
                break;
            case '':
            case -78:   //utf-8
                chfunc[j] = 149;
                break;
            case '':
            case -69:   //utf-8
                chfunc[j] = 150;
                break;
            case '':
            case -71:   //utf-8
                chfunc[j] = 151;
                break;
            case '':
            case -65:   //utf-8
                chfunc[j] = 152;
                break;
            case '':
            case -79:   //utf-8
                chfunc[j] = 164;
                break;
            case '':
            case -93:   //utf-8
                chfunc[j] = 198;
                break;
            case '':
            case -75:   //utf-8
                chfunc[j] = 228;
                break;
            default:
                chfunc[j] = texte[i];   //Si ce n'est pas un caractre spcial, copie directe
        }
    }
    #else   //linux
    char chaine_locale[4096];   //Evite une erreur lie semble-t-il  une redondance de chfunc
    strcpy(chfunc,linux_acc(texte,chaine_locale));
    #endif
    return (chfunc);
}

char* linux_acc (const char* texte, char* chfunc)
{
    int i,j;
    for (i=0,j=0;i<=(int)strlen(texte);i++,j++)
    {
        if(texte[i] < 0)    //caractre spcial
        {
            if(texte[i] == -61)    //-61 correponds aux caractres accentu en UTF-8
            {   //Codage d'entre en UTF-8
                chfunc[j++] = 195;  //Premire valeur des caractres spciaux
                chfunc[j] = texte[++i]+256;
            }
            else if(texte[i] > -33 && texte[i] < 0) //Entre -32 et -1, caractres accentu en iso latin
            {   //Codage d'entre en iso latin
                chfunc[j++] = 195;  //Premire valeur des caractres spciaux
                chfunc[j] = texte[i]+192;
            }
            else
                chfunc[j] = texte[i];   //Si caractre non reconnu, copie directe
        }
        else
            chfunc[j] = texte[i];   //Si caractre normal, copie directe
    }
    return (chfunc);
}

char* linux_utf_to_iso (const char* texte, char* chfunc)
{   //Transforme la chaine d'entre UTF-8 en iso-latin (iso8859-1)
    #ifndef WIN32    //linux; windows ne possde pas le headers iconv.h...
    char* chaine;
    ER = (int) (chaine = (char*) malloc(sizeof(char)*strlen(texte)*2));
    Erreur(1);
    strcpy(chaine,texte);
    chfunc = exp_iconv(chaine,"UTF8","ISO_8859-1",chfunc);
    free(chaine);
    #else
    strcpy(chfunc,texte);   //Copie direct pour windows
    #endif
    return (chfunc);
}

char* exp_iconv(char* chaine, const char* from_charset, const char* to_charset, char* chfunc)
{
        #ifndef WIN32    //linux; windows ne possde pas le headers iconv.h...
        iconv_t cd;
        size_t taille_ch, taille_ch2;
        char *chaine2, *ptr;
        strcpy(chfunc,chaine);
        cd = iconv_open(to_charset, from_charset);  //Alloue un descripteur pour la conversion
        if (cd != (iconv_t) (-1))   //Si pas d'erreur.
        {
            taille_ch = strlen(chfunc);
            /* the maximum expansion when converting happens when converting
               ascii to utf-8; each ascii char can become up to 4 unicode chars
               and each one of those unicode chars can be 3 bytes long */
            chaine2 = (char*) malloc(4 * 3 * taille_ch);  //http://manpagesfr.free.fr/man/man3/alloca.3.html        //Dclare buffer
            ptr = chaine2;      //Le pointeur pointe sur l'espace allou
            taille_ch2 = 4 * 3 * taille_ch;    //Fixe la taille de la chaine du pointeur
            //size_t iconv(iconv_t cd,char **inbuf, size_t *inbytesleft,char **outbuf, size_t *outbytesleft);
            if ((iconv(cd, &chaine, &taille_ch, &ptr, &taille_ch2)) != (size_t) (-1))  //Effectue la conversion et vrifie le retour.
                chfunc = chaine2;   //Copie chaine2 dans la chaine de retour
            iconv_close(cd);    //Libre le descripteur
            free(chaine2);
        }
        #endif
        return chfunc;  //Renvoi la nouvelle chaine de caractres; En cas d'erreur, la chaine est renvoye sans avoir t modifie
}

char* invers_acc (const char* chaine, char* chfunc)    /*Permute les accents, en donnant les codes ascii correspondant pour l'ouverture de fichier*/
{
    #ifdef WIN32    //win
    int i, j;
    for (i=0,j=0;i<=(int)strlen(chaine);i++,j++)
    {
        if(chaine[i] == -61)    //Caratre cod en utf-8
            i++;    //Saute au caractre suivant (UTF-8 est cod sur 2 valeur, ici c'est la seconde qui nous intresses
        switch(chaine[i])
        {
            case 129:
            case -68:   //utf-8
            case -127:
                chfunc[j] = '';
                break;
            case 130:
            case -87:   //utf-8
            case -126:
                chfunc[j] = '';
                break;
            case 131:
            case -94:   //utf-8
            case -125:
                chfunc[j] = '';
                break;
            case 132:
            case -124:
            //case -92:   //utf-8 le  est peu utilis, il entre en conflit avec le 164 (), il sera donc  bannir des noms de fichier!
                chfunc[j] = '';
                break;
            case 133:
            case -96:   //utf-8
            case -123:
                chfunc[j] = '';
                break;
            case 135:
            case -89:   //utf-8
            case -121:
                chfunc[j] = '';
                break;
            case 136:
            case -86:   //utf-8
            case -120:
                chfunc[j] = '';
                break;
            case 137:
            case -85:   //utf-8
            case -119:
                chfunc[j] = '';
                break;
            case 138:
            case -88:   //utf-8
            case -118:
                chfunc[j] = '';
                break;
            case 139:
            case -81:   //utf-8
            case -117:
                chfunc[j] = '';
                break;
            case 140:
            case -82:   //utf-8
            case -116:
                chfunc[j] = '';
                break;
            case 141:
            case -84:   //utf-8
            case -115:
                chfunc[j] = '';
                break;
            case 147:
            case -76:   //utf-8
            case -109:
                chfunc[j] = '';
                break;
            case 148:
            case -74:   //utf-8
            case -108:
                chfunc[j] = '';
                break;
            case 149:
            case -78:   //utf-8
            case -107:
                chfunc[j] = '';
                break;
            case 150:
            case -69:   //utf-8
            case -106:
                chfunc[j] = '';
                break;
            case 151:
            case -71:   //utf-8
            case -105:
                chfunc[j] = '';
                break;
            case 152:
            case -65:   //utf-8
            case -104:
                chfunc[j] = '';
                break;
            case 164:
            case -79:   //utf-8
            case -92:
                chfunc[j] = '';
                break;
            case 198:
            case -93:   //utf-8
            case -58:
                chfunc[j] = '';
                break;
            case 228:
            case -75:   //utf-8
            case -28:
                chfunc[j] = '';
                break;
            default:
                chfunc[j] = chaine[i];   //Si ce n'est pas un caractre spcial, copie directe
        }
    }
    #endif
    return (chfunc);
}

void Erreur (int nb_erreur)    /*Fonction vrifiant la possibilit d'une erreur*/
{
//    if (ER == NULL) /*Si ER vaut NULL, c'est que la fonction  renvoyer une erreur*/
    if (ER == 0) /*Si ER vaut NULL, c'est que la fonction  renvoyer une erreur*/
    {
        #ifdef WIN32    /*win*/
            system("color FC");
        #endif
        switch (nb_erreur)
        {
            case 1:
                putsacc("\nErreur d'allocation de mmoire, la mmoire vive est insuffisante.\n");
                perror("malloc");   //En test
                break;
            case 2:
                putsacc("\nErreur lors de la saisie au clavier.\n");
                perror("gets");   //En test
                break;
        }
        DPause();
        exit(1);
    }
}

void Efface_char (char *chaine, const char *borne)    /*Efface les caractres d'une chane jusqu' la borne, puis efface la borne.*/
{
    int i, j;
    if(strstr(chaine,borne) != NULL)
    {
        strcpy(chaine,strstr(chaine,borne));    /*Efface tout ce qui se trouve avant la borne*/
        for(j=0;j<(int)strlen(borne);j++)
        {
            for(i=0;i<(int)strlen(chaine);i++)
                chaine[i] = chaine[i+1]; /*Efface la borne*/
        }
    }
}

void Efface_n (char* chaine)
{
    int i;
    if((i = strlen(chaine)-5) < 0)
        i=0;    //i commence  -5 de la fin de la chaine pour viter de parcourir toute la boucle alors que seule la fin nous intresse ici. Si la chaine est plus petite que 5, i commence  0
    for(;i<(int)strlen(chaine);i++)    //Commence la boucle  strlen(chaine)-5 pour traiter seulement la fin de la chaine
    {   //10 = ligne suivante   13 = Dbut de ligne
        if(chaine[i] == 10 || chaine[i] == 13)
            chaine[i] = '\0';
    }
}

void accent_redir_dos ()   /*Change la page de code du mode dos, ce qui permet  la commande dos de grer les accents. Trs utile dans le cas d'une redirection de sortie vers un fichier.*/
{   /*Change la page de code, 1252 correspond  une page de code unicode. Du coup les accents passe correctement*/
    system("chcp 1252 > temp.tmp");
}

void annul_accent_redir_dos () /*Rtablit la page de code normale du dos.*/
{
    system("chcp 437 > temp.tmp");
}

char* Local_user(char* user) /*Dtermine le login de l'utilisateur actuel*/
{   //Fonction rserve Windows
    FILE* temp;
    system("cd %userprofile% && cd > c:\\temp.tmp");    /*Renvoi le chemin du profile de l'utilisateur dans un fichier temporaire*/
    temp = fopen("c:\\temp.tmp","r");
    fgets(user,255,temp);   /*Relis le chemin*/
    fclose(temp);
    do
    {
        Efface_char(user,"\\"); /*Efface tout le dbut du chemin, pour ne garder que le nom de l'user*/
    }while(strstr(user,"\\"));
    user[strlen(user)-1] = '\0';
    return user;
}

char* Disk_system (char* disque)   /*Dtermine la lettre du disque systme*/
{   //Fonction rserve Windows
    FILE* temp;
    char chaine[255];
//    system("cd %systemroot% && cd > c:\\temp.tmp");    /*Renvoi le chemin du systme dans un fichier temporaire*/
    system("cd %systemroot% > c:\\temp.tmp");
    temp = fopen("c:\\temp.tmp","r");
    fgets(chaine,255,temp); /*Relis le chemin*/
    fclose(temp);
    disque[0] = chaine[0];  /*Prend juste la lettre de lecteur*/
    disque[1] = '\0';
    return disque;
}

char* inttochar (int entier, char* chaine)
{
    snprintf(chaine, 11, "%d", entier);
    return chaine;
}

void changeslash (char *chaine)     //Change les slash pour la compatibilit linux
{
    #ifndef WIN32   //linux
    int i;
    for(i=0;i<(int)strlen(chaine);i++)
    {
        if(chaine[i] == '\\')   //Si prsence de \ (win)
            chaine[i] = '/';    //Change en / (linux)
    }
    #endif
}

#endif
